% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.
%
% Chapter 10: Frequency Response Techniques
%
% (ch10p1) Example 10.3: We can use MATLAB to make Bode plots using 
% bode(G), where G(s) = numg/deng and G is an LTI transfer-function object. 
% Information about the plots obtained with bode(G) can be found by 
% left-clicking the mouse on the curve. You can find the curve's label, 
% as well as the coordinates of the point on which you clicked. Right 
% clicking away from a curve brings up a menu if the icons on the menu bar 
% are deselected. From this menu you can select (1) system responses to be 
% displayed and (2) characteristics, such as peak response.
% When selected, a dot appears on the curve at the appropriate point.
% Let your mouse rest on the point to read the value of the characteristic. 
% You also may select (3) which curves to view, (4) choice for grid on or off, 
% (5) returning to full view after zooming, and (6) properties, such as labels,
% limits, units, style, and characteristics. We can obtain points on the plot 
% using [mag,phase,w] = bode(G), where magnitude, phase, and frequency are 
% stored in mag, phase, and w, respectively, Magnitude and phase are 
% stored as 3-D arrays. We use mag(:,:)',phase(:,:)' to convert the 
% arrays to column vectors, where the apostrophe signifies matrix transpose. 
% Let us look at Example 10.3 in the text.

'(ch10p1) Example 10.3'             % Display label.
clf                                 % Clear graph.
numg=[1 3];                         % Define numerator of G(s).
deng=conv([1 2],[1 2 25]);          % Define denominator of G(s).
'G(s)'                              % Display label.
G=tf(numg,deng)                     % Create and display G(s).
bode(G)                             % Make a Bode plot.
grid on                             % Turn on grid for Bode plot.
title('Open-Loop Frequency Response')		
                                    % Add a title to the Bode plot.
[mag,phase,w]=bode(G);              % Store points on the Bode plot.
points=[20*log10(mag(:,:))',phase(:,:)',w]	
                                    % List points on Bode plot with 
                                    % magnitude in dB.
